@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Tenant Details</h3>
                    <a href="{{ route('tenants.index') }}" class="btn btn-secondary float-right">Back</a>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th>ID</th>
                            <td>{{ $tenant->id }}</td>
                        </tr>
                        <tr>
                            <th>Name</th>
                            <td>{{ $tenant->name }}</td>
                        </tr>
                        <tr>
                            <th>Domain</th>
                            <td>{{ $tenant->domain }}</td>
                        </tr>
                        <tr>
                            <th>Subdomain</th>
                            <td>{{ $tenant->subdomain }}</td>
                        </tr>
                        <tr>
                            <th>Created At</th>
                            <td>{{ $tenant->created_at }}</td>
                        </tr>
                        <tr>
                            <th>Updated At</th>
                            <td>{{ $tenant->updated_at }}</td>
                        </tr>
                    </table>
                    <h4>Users</h4>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($tenant->users as $user)
                            <tr>
                                <td>{{ $user->id }}</td>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->email }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
